<?php $__env->startSection('title'); ?>
    <?php echo e(__('subscription_settings')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <?php echo e(__('subscription_settings')); ?>

            </h3>
        </div>
        <div class="row grid-margin">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <form id="formdata" class="create-form-without-reset"
                            action="<?php echo e(route('system-settings.subscription-settings-store')); ?>" method="POST"
                            data-success-function="formSuccessFunction" novalidate="novalidate"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            
                            <div class="border border-secondary rounded-lg my-4 mx-1">
                                <div class="col-md-12 mt-3">
                                    <h4><?php echo e(__('subscription_settings')); ?></h4>
                                </div>
                                <div class="col-12 mb-3">
                                    <hr class="mt-0">
                                </div>
                                <div class="row my-4 mx-1">
                                    <div class="form-group col-md-3 col-sm-12">
                                        <label for="additional_billing_days"><?php echo e(__('Additional Billing Days')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input name="additional_billing_days" id="additional_billing_days"
                                            value="<?php echo e($settings['additional_billing_days'] ?? ''); ?>" min="2"
                                            type="number" required placeholder="<?php echo e(__('Additional Billing Days')); ?>"
                                            class="form-control" />
                                    </div>

                                    <div class="form-group col-md-3 col-sm-12">
                                        <label
                                            for="current_plan_expiry_warning_days"><?php echo e(__('Current Plan Expiry Warning Days')); ?>

                                            <span class="text-danger">*</span></label>
                                        <input name="current_plan_expiry_warning_days" id="current_plan_expiry_warning_days"
                                            value="<?php echo e($settings['current_plan_expiry_warning_days'] ?? ''); ?>"
                                            min="2" type="number" required
                                            placeholder="<?php echo e(__('Current Plan Expiry Warning Days')); ?>"
                                            class="form-control" />
                                    </div>

                                    <div class="form-group col-sm-12 col-md-12 mt-3">
                                        <label for=""><strong><?php echo e(__('Cron Job URL')); ?></strong> :</label>

                                        <?php echo Form::text('info-link', url('subscription/cron-job'), ['class' => 'form-control', 'readonly']); ?>

                                    </div>

                                    <div class="form-group col-sm-12 col-md-12">
                                        <div class="alert alert-danger" role="alert">
                                            <?php echo e(__('Kindly configure the cron job on your server to execute the URL every day This will facilitate the regular examination of school subscription expirations and the creation of bills')); ?>

                                        </div>
                                    </div>

                                </div>
                            </div>
                            

                            

                            <div class="border border-secondary rounded-lg my-4 mx-1">
                                <div class="col-md-12 mt-3">
                                    <h4><?php echo e(__('free_trial_subscription_settings')); ?></h4>
                                </div>
                                <div class="col-12 mb-3">
                                    <hr class="mt-0">
                                </div>
                                <div class="row my-4 mx-1">
                                    <div class="form-group col-md-6 col-lg-6 col-xl-4 col-sm-12">
                                        <label for="trial_days"><?php echo e(__('trial_days')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input name="trial_days" id="trial_days"
                                            value="<?php echo e($settings['trial_days'] ?? ''); ?>" min="1" type="number"
                                            required placeholder="<?php echo e(__('trial_days')); ?>" class="form-control" />
                                    </div>

                                    <div class="form-group col-md-6 col-lg-6 col-xl-4 col-sm-12">
                                        <label for="student_limit"><?php echo e(__('student_limit')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input name="student_limit" id="student_limit"
                                            value="<?php echo e($settings['student_limit'] ?? ''); ?>" min="1" type="number"
                                            required placeholder="<?php echo e(__('student_limit')); ?>" class="form-control" />
                                    </div>

                                    <div class="form-group col-md-6 col-lg-6 col-xl-4 col-sm-12">
                                        <label for="staff_limit"><?php echo e(__('staff_limit')); ?>

                                            <span class="text-danger">*</span></label>
                                        <input name="staff_limit" id="staff_limit"
                                            value="<?php echo e($settings['staff_limit'] ?? ''); ?>" min="1" type="number"
                                            required placeholder="<?php echo e(__('staff_limit')); ?>" class="form-control" />
                                    </div>
                                    <div class="form-group col-md-6 col-lg-6 col-xl-6 col-sm-12">
                                        <label for="description"><?php echo e(__('description')); ?></label>
                                        <textarea name="free_trial_subscription_description" placeholder="<?php echo e(__('description')); ?>" class="form-control"><?php echo e($package ? $package->description : ''); ?></textarea>
                                    </div>

                                    <div class="form-group col-sm-12 col-md-3 mt-4">
                                        <div class="form-group row ml-3">
                                            <div class="form-check col-sm-12 col-md-6 form-check-primary">
                                                <label class="form-check-label">
                                                    <input type="radio" class="form-check-input" value="1" name="status" <?php echo e($package ? $package->status == 1 ? 'checked' : '' : ''); ?>>
                                                    <?php echo e(__('active')); ?>

                                                    <i class="input-helper"></i>
                                                </label>
                                            </div>
                                            <div class="form-check col-sm-12 col-md-6 form-check-primary">
                                                <label class="form-check-label">
                                                    <input type="radio" class="form-check-input" value="0" name="status" <?php echo e($package ? $package->status == 0 ? 'checked' : '' : ''); ?>>
                                                    <?php echo e(__('inactive')); ?>

                                                    <i class="input-helper"></i>
                                                </label>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-2 mt-4">
                                        <div class="form-check">
                                            <label class="form-check-label d-inline">
                                                <?php echo Form::checkbox('highlight', 1, $package ? $package->highlight : false, ['class' => 'form-check-input']); ?>

                                                <?php echo e(__('highlight')); ?> <?php echo e(__('package')); ?>

                                            </label>
                                        </div>
                                    </div>

                                </div>
                                
                                <div class="row my-4 mx-1">
                                    <div class="col-sm-12 col-md-12 mb-3 text-center">
                                        <h4 class="card-title"><?php echo e(__('features')); ?></h4>
                                    </div>
                                    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group col-sm-12 col-md-3 d-flex justify-content-center">
                                            
                                            <?php if($feature->is_default == 1): ?>
                                                <input id="<?php echo e(__($feature->name)); ?>" class="feature-checkbox" disabled
                                                    type="checkbox" name="feature_id[]"
                                                    <?php if($package && str_contains($package->package_feature->pluck('feature_id'), $feature->id)): ?> checked <?php endif; ?>
                                                    value="<?php echo e($feature->id); ?>" />
                                                <label class="feature-list-default text-center"
                                                    for="<?php echo e(__($feature->name)); ?>"
                                                    title="<?php echo e(__('default_feature')); ?>"><?php echo e(__($feature->name)); ?></label>
                                                <input type="hidden" name="feature_id[]" value="<?php echo e($feature->id); ?>">
                                            <?php else: ?>
                                                <input id="<?php echo e(__($feature->name)); ?>" class="feature-checkbox"
                                                    type="checkbox" name="feature_id[]"
                                                    <?php if($package && in_array($feature->id, $package->package_feature->pluck('feature_id')->toArray())): ?> checked <?php endif; ?>
                                                    value="<?php echo e($feature->id); ?>" />
                                                <label class="feature-list text-center"
                                                    for="<?php echo e(__($feature->name)); ?>"><?php echo e(__($feature->name)); ?></label>
                                            <?php endif; ?>

                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                                <hr>
                            </div>

                            

                            <input class="btn btn-theme float-right ml-3" id="create-btn" type="submit" value=<?php echo e(__('submit')); ?>>
                            <input class="btn btn-secondary float-right" type="reset" value=<?php echo e(__('reset')); ?>>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function formSuccessFunction(response) {
            setTimeout(() => {}, 500);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/paksrrzs/school.paksofto.com/resources/views/settings/subscription-settings.blade.php ENDPATH**/ ?>