<?php
    $lang = Session::get('language');
?>
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/materialdesignicons.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/vendor.bundle.base.css')); ?>">

<link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/font-awesome.min.css')); ?>"/>
<link rel="stylesheet" href="<?php echo e(asset('/assets/select2/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/jquery-toast-plugin/jquery.toast.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/color-picker/color.min.css')); ?>">
<?php if($lang): ?>
    <?php if($lang->is_rtl): ?>
        <link rel="stylesheet" href="<?php echo e(asset('/assets/css/rtl.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('/assets/css/custom-rtl.css')); ?>">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('/assets/css/style.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('/assets/css/custom.css')); ?>">
    <?php endif; ?>
<?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/custom.css')); ?>">
<?php endif; ?>

<link rel="stylesheet" href="<?php echo e(asset('/assets/css/comman.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/datepicker.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/daterangepicker.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/ekko-lightbox.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/css/jquery.tagsinput.min.css')); ?>">


<link rel="stylesheet" href="https://unpkg.com/bootstrap-table@1.22.1/dist/bootstrap-table.min.css">
<link rel="stylesheet" href="<?php echo e(asset('/assets/bootstrap-table/fixed-columns.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/assets/bootstrap-table/reorder-rows.css')); ?>">

<script src="<?php echo e(asset('/assets/js/vendor.bundle.base.js')); ?>"></script>
<script src='<?php echo e(asset('/assets/js/fullcalendar.js')); ?>'></script>


<link rel="shortcut icon" href="<?php echo e($schoolSettings['favicon'] ?? $systemSettings['favicon'] ?? url('assets/vertical-logo.svg')); ?>"/>




<script src="<?php echo e(url('/js/lang')); ?>"></script>
<style>
    :root {
        --theme-color: <?=$systemSettings['theme_color']??"#22577A" ?>;
    }
    /* Custom styles for sidebar sub-categories */
    .sub-category {
        padding: 10px 0 5px 15px;
        font-weight: bold;
        color: #6c7293;
        font-size: 0.9rem;
        text-transform: uppercase;
        margin-top: 10px;
        border-left: 3px solid #3e4b5b;
    }
    .nav-item.pl-3 .nav-link {
        padding-left: 15px !important;
        font-size: 0.85rem;
    }
    .nav-item.pl-3 .nav-link i.small-icon {
        font-size: 8px;
        margin-right: 5px;
        vertical-align: middle;
    }
</style>
<script>
    const baseUrl = "<?php echo e(URL::to('/')); ?>";

    // Function to handle image errors
    function handleImageError(image) {
        image.classList.contains('custom-default-image')
        if (image.getAttribute('data-custom-image') != null) {
            image.src = image.getAttribute('data-custom-image');
        } else {
            image.src = "<?php echo e(asset('/assets/no_image_available.jpg')); ?>";
        }
    }

    // Create a MutationObserver to watch for DOM changes
    const observer = new MutationObserver((mutationsList) => {
        mutationsList.forEach((mutation) => {
            if (mutation.addedNodes) {
                mutation.addedNodes.forEach((node) => {
                    // Check if the added node is an image element
                    if (node instanceof HTMLImageElement) {
                        node.addEventListener('error', () => {
                            handleImageError(node);
                        });
                    }
                });
            }
        });
    });

    // Start observing changes in the DOM
    observer.observe(document, {childList: true, subtree: true});

    const onErrorImage = (e) => {
        e.target.src = "<?php echo e(asset('/assets/no_image_available.jpg')); ?>";
    };

    const onErrorImageSidebarHorizontalLogo = (e) => {
        e.target.src = "<?php echo e(asset('/assets/vertical-logo.svg')); ?>";
    };
</script>
<?php /**PATH /home/paksrrzs/school.paksofto.com/resources/views/layouts/include.blade.php ENDPATH**/ ?>