<?php $__env->startSection('title'); ?>
    <?php echo e(__('Payment Settings')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <?php if(Auth::user()->school_id): ?>
                    <?php echo e(__('fees_payment_settings')); ?>

                <?php else: ?>
                    <?php echo e(__('Payment Settings')); ?>

                <?php endif; ?>
            </h3>
        </div>
        <div class="row grid-margin">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <form class="create-form-without-reset" action="<?php echo e(route('system-settings.payment.update')); ?>"
                            method="POST" novalidate="novalidate" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            
                            <?php echo $__env->make('settings.forms.payment-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <input class="btn btn-theme float-right ml-3" id="create-btn" type="submit"
                                value=<?php echo e(__('submit')); ?>>
                            <input class="btn btn-secondary float-right" type="reset" value=<?php echo e(__('reset')); ?>>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        window.onload = setTimeout(() => {
            $('#currency_code').trigger("change");
        }, 500);

        <?php if(!empty($paymentGateway['Stripe']['currency_code'])): ?>
            $('#currency_code').val("<?php echo e($settings['currency_code']); ?>").trigger("change");
        <?php endif; ?>

        $('#currency_code').on('change', function() {
            $('#stripe_currency').val($(this).val());
        })

        $('#currency_code').on('change', function() {
            $('#razorpay_currency').val($(this).val());
        })

        $('#currency_code').on('change', function() {
            $('#flutterwave_currency').val($(this).val());
        })

        $('#currency_code').on('change', function() {
            $('#paystack_currency').val($(this).val());
        })

        $('#currency_code').on('change', function() {
            $('#bank_transfer_currency').val($(this).val());
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/paksrrzs/school.paksofto.com/resources/views/settings/payment.blade.php ENDPATH**/ ?>